#pragma once

#include <windows.h>

#include "VRPNDLLClientStructs.h"
#include "vrpn_Analog.h"
#include "vrpn_Button.h"
#include "vrpn_Analog_Output.h"

#include <vector>

// Main class
class VRPNDLLClient
{
	// --------------------------------------------------------------------------------
	// Singleton pattern
private:
	static VRPNDLLClient * smIntance;
	VRPNDLLClient(void);

public:
	~VRPNDLLClient(void);
	static VRPNDLLClient * GetInstance();

	// --------------------------------------------------------------------------------
	// DLL Client Device class

private:
	bool stopDll;

	// --------------------------------------------------------------------------------
	// DLL Device attributes
	std::string deviceConnection;

	int buttonsChannel;

	int deltaXChannel;
	int deltaYChannel;
	int deltaZChannel;

	int yawChannel;
	int pitchChannel;
	int rollChannel;

	HANDLE deviceThreadHandle;
	
	vrpn_Button_Remote * mButton;
	vrpn_Analog_Remote * mAnalog;

	int buttons;
	float deltaX;
	float deltaY;
	float deltaZ;
	float yaw;
	float pitch;
	float roll;

public:
	void Start();
	void Stop();

	// --------------------------------------------------------------------------------
	// DLL Device Methods

	static DWORD WINAPI ThreadDevice (LPVOID pArg);

	void SetupDevice( const char * deviceName, int buttonsChannel, int yawChannel, int pitchChannel, int rollChannel, int deltaXChannel, int deltaYChannel, int deltaZChannel);
	
	void RunDevice();
	
	static void VRPN_CALLBACK handle_analog( void* userData, const vrpn_ANALOGCB a );
	
	void ProcessAnalog( const vrpn_ANALOGCB a );

	int Buttons(){ return buttons; }

	float Yaw() { return yaw; }
	float Pitch(){ return pitch; }
	float Roll(){ return roll; }

	float DeltaX() { return deltaX; }
	float DeltaY() { return deltaY; }
	float DeltaZ() { return deltaZ; }
};
